unit Scope01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, StdCtrls;

type TScope = class(TObject)
private
  // ------------------------
  fImg         : TImage;    //  Image
  // ------------------------
  //   
  fXBeg        : integer;   // X -  
  fYBeg        : integer;   // Y -  
  fSRect       : TRect;     //   
  // ------------------------
  fCompact     : boolean;   //  
  fTransparent : boolean;   //     
  // ------------------------
  //    
  fCGW         : integer;   //   
  fCGH         : integer;   //   
  // ------------------------
  //    
  fIRect       : TRect;     //   
  fVRect       : TRect;     //   
  fGRect       : TRect;     //   
  fTRect       : TRect;     //   
  fTitle       : string;    //  
  fBmp         : TBitMap;   //    
  // ------------------------
  //   
  fMeasure     : string;    //  
  fMin         : extended;  //   
  fMax         : extended;  //   
  fScale       : extended;  // 
  fYZone       : extended;  //    
  fRZone       : extended;  //    
  fValue       : extended;  //  
  //  
  fVisible     : boolean;   //  
  // ------------------------
  //     
  procedure CalcSRect();
  // ------------------------
  //     fImg
  procedure SetXBeg(XBeg : integer);
  procedure SetYBeg(YBeg : integer);
  procedure SetTitle (Title : string);
  // ------------------------
  //    
  procedure CalcScale();
  //      
  function  GetGW(Value : extended) : integer;

  // ------------------------
  //     fImg
  procedure RestoreBkGround();
  procedure SaveBkGround();
  function  TestBkGround() : boolean;
  procedure SetVisible(Visible : boolean);
  procedure SetCompact(Compact : boolean);
  procedure SetTransparent(Transparent : boolean);

  // ------------------------
  //   
  procedure SetMeasure(Measure : string);
  procedure SetMin   (Min  : extended);
  procedure SetMax   (Max  : extended);
  procedure SetCGW   (GLen : integer);
  // ------------------------
  //   
  procedure SetYZone (YZone : extended);
  procedure SetRZone (RZone : extended);

public
  // ------------------------
  //  / 
  constructor  Create(RqImage : TImage);
  procedure Free();
  // ------------------------
  //  
  procedure DrawScope();
  // ------------------------
  //  
  property SRect   : TRect  read fSRect;
  // ------------------------
  //  
  property Visible : boolean read fVisible write SetVisible;
  property Compact : boolean read fCompact write SetCompact;
  property Transparent : boolean read fTransparent write SetTransparent;

  property XBeg  : integer  read fXBeg  write SetXBeg;
  property YBeg  : integer  read fYBeg  write SetYBeg;
  property Title : string   read fTitle write SetTitle;
  // ------------------------
  //     
  property Measure : string read fMeasure write SetMeasure;
  property Min  : extended read fMin write SetMin;
  property Max  : extended read fMax write SetMax;
  property GLen : integer  read fCGW write SetCGW;
  // ------------------------
  //  
  property Value : extended read fValue write fValue;
  // ------------------------
  //    
  property YZone : extended read fYZone write SetYZone;
  property RZone : extended read fRZone write SetRZone;
  // ------------------------

end;

implementation

// -------------------------------------------------------------------------
const cWIcon  = 12;
      cHIcon  = 12;
      cWBound = 4;
      cHBound = 4;
      cTxtPic = ' 123,123 ';
      cOutPic = '%6.3f';
// -------------------------------------------------------------------------
constructor TScope.Create(RqImage : TImage);
begin
   inherited Create;
   // -------------------------------
   //  fImg
   fImg   := RqImage;
   if not Assigned(fImg.Picture) then fImg.Picture := TPicture.Create;
   with fImg.Picture.Bitmap
   do begin
      if Width  <> fImg.Width   then Width  := fImg.Width;
      if Height <> fImg.Height  then Height := fImg.Height;
      if PixelFormat <> pf24bit then PixelFormat := pf24bit;
   end;
   // -------------------------------
   //   
   fXBeg    := 0;
   fYBeg    := 0;
   //  
   fTitle   := 'K ';
   fCGW     := 100;     //   
   fCGH     := 8;       //   
   fCompact     := False;
   fTransparent := True;
   // -------------------------------
   //    
   fBmp := TBitMap.Create;
   CalcSRect();
   SaveBkGround();
   // -------------------------------
   //  
   fMeasure := ' . ';
   fMin   := 20;
   fMax   := 80;
   fValue := fMin;
   CalcScale();
end;

// -------------------------------------------------------------------------
procedure TScope.Free();
begin
   if Assigned(fBmp)
   then begin
       RestoreBkGround();
       fBmp.Free();
   end;
   inherited Free();
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//     
procedure TScope.CalcSRect();
var wH, wW : integer;
begin
  with fImg
  do begin
     //   
     fIRect.Top    := fYBeg + cHBound;
     fIRect.Left   := fXBeg + cWBound;
     fIRect.Bottom := fIRect.Top  + cHIcon;
     fIRect.Right  := fIRect.Left + cWIcon;
     //  
     wW := fIRect.Right  + cWBound;
     //   
     fVRect.Top    := fIRect.Top;
     fVRect.Left   := wW + cWBound;
     fVRect.Bottom := fVRect.Top  + Canvas.TextHeight('0');
     fVRect.Right  := fVRect.Left
                   + Canvas.TextWidth(cTxtPic + ' ' + fMeasure + ' ');
     //   
     if fVRect.Bottom > fIRect.Bottom
     then wH := fVRect.Bottom + cHBound
     else wH := fIRect.Bottom + cHBound;
     wW := fVRect.Right  + cWBound;
     //  
     if not fCompact
     then begin
       //   
       fGRect.Top    := wH;
       fGRect.Left   := fXBeg + cWBound;
       fGRect.Bottom := fGRect.Top  + fCGH;
       fGRect.Right  := fGRect.Left + fCGW;
       //   
       if fGRect.Right  + cWBound > wW
       then wW := fGRect.Right + cHBound;
       wH := fGRect.Bottom + cHBound;
       if fTitle <> ''
       then begin
         //   
         fTRect.Top    := wH;
         fTRect.Left   := fXBeg + cWBound;
         fTRect.Bottom := fTRect.Top  + Canvas.TextHeight('0');
         fTRect.Right  := fTRect.Left + Canvas.TextWidth(' ' + fTitle + ' ');
         //   
         if fTRect.Right  + cWBound > wW
         then wW := fTRect.Right + cHBound;
         wH := fTRect.Bottom + cHBound;
       end;
     end;
     //   
     fSRect.Top    := fYBeg;
     fSRect.Left   := fXBeg;
     fSRect.Bottom := wH;
     fSRect.Right  := wW;
  end;
end;
// -------------------------------------------------------------------------
function SaveBitMap(FromBitMap, Bitmap : TBitmap;
                    FomRect : TRect) : boolean;
//  ------------------------------------
//  SysUtils:
//  PByteArray = ^TByteArray;
//  TByteArray = array[0..32767] of Byte;
//  ------------------------------------
var
  RowBeg,  ColBeg : Integer;
  RowEnd,  ColEnd : Integer;
  PFrom,   PTo    : PByteArray;
  RowFrom, RowTo  : Integer;
  ColFrom, ColTo  : Integer;
begin
  Result := False;
  if not (FromBitMap.PixelFormat = pf24bit) then Exit;
  //    FomRec
  // 1) FomRect   FromBitMap
  if FomRect.Top  >= FromBitMap.Height then Exit;
  if FomRect.Left >= FromBitMap.Width  then Exit;
  // 2)   
  RowBeg := FomRect.Top;
  if RowBeg < 0 then RowBeg := 0;
  RowEnd := FomRect.Bottom;
  if RowEnd > FromBitMap.Height - 1 then RowEnd := FromBitMap.Height - 1;
  // 3)   
  ColBeg := FomRect.Left;
  if ColBeg < 0 then ColBeg := 0;
  ColEnd := FomRect.Right;
  if ColEnd > FromBitMap.Width - 1 then ColEnd := FromBitMap.Width - 1;
  // 4)    FomRec
  if RowEnd < RowBeg  then Exit;
  if ColEnd < ColBeg  then Exit;
  //  
  try
     Bitmap.PixelFormat := pf24bit;
     Bitmap.Height := RowEnd - RowBeg + 1;
     Bitmap.Width  := ColEnd - ColBeg + 1;
     RowTo := 0;
     for RowFrom := RowBeg to RowEnd do
     begin
       //   BitMap     
       PFrom := FromBitMap.ScanLine[RowFrom];
       PTo   := Bitmap.ScanLine[RowTo];
       //  .     pf24bit : B,G,R
       ColTo := 0;
       for ColFrom := ColBeg * 3 to ColEnd * 3
       do begin
          PTo^[ColTo] := PFrom^[ColFrom];
          Inc(ColTo);
       end;
       Inc(RowTo);
     end;
     Result := True;
  except
     ShowMessage('   BitMap');
  end;
end; // of function

// -------------------------------------------------------------------------
function RestoreBitMap(BitMap   : TBitmap;  // BitMap 
                       ToBitMap : TBitmap;  // BitMap 
                       Xb, Yb   : integer)  //    
                       : boolean;
var
  RowBeg,  ColBeg : Integer;
  RowEnd,  ColEnd : Integer;
  PFrom,   PTo    : PByteArray;
  RowFrom, RowTo  : Integer;
  ColFrom, ColTo  : Integer;
begin
  Result := False;
  if not (ToBitmap.PixelFormat = pf24bit) then Exit;
  //    FomRec
  // 1) Xb, Yb   ToBitMap
  if Yb >= ToBitmap.Height then Exit;
  if Xb >= ToBitmap.Width  then Exit;
  // 2)   
  RowBeg := Yb;
  if Yb < 0
  then begin
      RowBeg := 0;
      RowEnd := BitMap.Height - 1;
  end
  else RowEnd := Yb + BitMap.Height - 1;
  if RowEnd  > ToBitMap.Height - 1 then RowEnd := ToBitMap.Height - 1;
  // 3)   
  ColBeg := Xb;
  if Xb < 0
  then begin
     ColBeg := 0;
     ColEnd := BitMap.Width - 1;
  end
  else ColEnd := Xb + BitMap.Width - 1;
  if ColEnd  > ToBitMap.Width - 1 then ColEnd := ToBitMap.Width - 1;
  // 4)    ToRec
  if RowEnd < RowBeg  then Exit;
  if ColEnd < ColBeg  then Exit;
  //  
  try
     RowFrom := 0;
     for RowTo := RowBeg to RowEnd do
     begin
       //    BitMap 
       //    
       PFrom := BitMap.ScanLine[RowFrom];
       PTo   := ToBitmap.ScanLine[RowTo];
       //   
       ColFrom := 0;
       for ColTo := ColBeg * 3 to ColEnd * 3
       do begin
          PTo^[ColTo] := PFrom^[ColFrom];
          Inc(ColFrom);
       end;
       Inc(RowFrom);
     end;
     Result := True;
  except
     ShowMessage('   BitMap');
  end;
end; // of function

// -------------------------------------------------------------------------
//   fSRect  fBmp
function  TScope.TestBkGround() : boolean;
begin
   Result := False;
   if Assigned(fBmp)
   then begin
      if fBmp.Height <> (fSRect.Bottom - fSRect.Top) + 1 then Exit;
      if fBmp.Width  <> (fSRect.Right - fSRect.Left) + 1 then Exit;
      Result := True;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TScope.RestoreBkGround();
begin
   if TestBkGround() and fVisible
   then begin
      //    fImg
      RestoreBitMap(fBmp, fImg.Picture.Bitmap, fSRect.Left,fSRect.Top);
      fImg.Refresh;
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TScope.SaveBkGround();
begin
   if Assigned(fBmp)
   then SaveBitMap(fImg.Picture.Bitmap, fBmp, fSRect);
end;
// -------------------------------------------------------------------------
//   
procedure TScope.SetVisible(Visible : boolean);
begin
  if Visible
  then begin
      if TestBkGround() and (not fVisible)
      then begin
         //    fImg
         fVisible := Visible;
         DrawScope();
      end;
  end
  else begin
      if TestBkGround() and fVisible
      then begin
          //    fImg
          RestoreBitMap(fBmp, fImg.Picture.Bitmap, fSRect.Left,fSRect.Top);
          fImg.Refresh;
          fVisible := Visible;
       end;
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TScope.SetCompact(Compact : boolean);
begin
   if fVisible then RestoreBkGround();
   fCompact := Compact;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//       
procedure TScope.SetTransparent(Transparent : boolean);
begin
   if fVisible then RestoreBkGround();
   fTransparent := Transparent;
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//    
procedure TScope.SetMeasure(Measure : string);
begin
   if fVisible then RestoreBkGround();
   fMeasure := Measure;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//  XBeg    fImg
procedure TScope.SetXBeg(XBeg : integer);
begin
   if fVisible then RestoreBkGround();
   if (XBeg < 0) or (XBeg > fImg.Width) then Exit;
   fXBeg := XBeg;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//  YBeg    fImg
procedure TScope.SetYBeg(YBeg : integer);
begin
   if fVisible then RestoreBkGround();
   if (YBeg < 0) or (YBeg > fImg.Height) then Exit;
   fYBeg := YBeg;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//   
procedure TScope.SetTitle (Title : string);
begin
   if fVisible then RestoreBkGround();
   fTitle := Title;
   CalcSRect();
   SaveBkGround();
   if fVisible then DrawScope();
end;
// -------------------------------------------------------------------------
//     
procedure TScope.CalcScale();
begin
  fScale := 0;
  if fMax <= fMin then Exit;
  fScale := fCGW / (fMax - fMin);
end;
// -------------------------------------------------------------------------
//        
function TScope.GetGW(Value : extended) : integer;
begin
   Result := 0;
   if fScale > 0
   then begin
      if Value > fMax
      then begin
         Result := Round(fScale * Abs(fMax - fMin));
         Exit;
      end;
      if Value < fMin
      then begin
         Result := 0;
         Exit;
      end;
      Result := Round(fScale * Abs(Value - fMin));
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TScope.SetMin(Min : extended);
begin
   if Min >= fMax then Exit;
   fMin := Min;
   fYZone := 0;
   fRZone := 0;
   CalcScale();
end;
// -------------------------------------------------------------------------
//    
procedure TScope.SetMax(Max : extended);
begin
   if Max <= fMin then Exit;
   fMax := Max;
   fYZone := 0;
   fRZone := 0;
   CalcScale();
end;
// -------------------------------------------------------------------------
//     
procedure TScope.SetCGW(GLen : integer);
begin
   if fVisible then RestoreBkGround();
   if GLen < cWIcon then fCGW := cWIcon;
   fCGW := GLen;
   CalcSRect();
   CalcScale();
   SaveBkGround();
   if fVisible then DrawScope();
end;

// -------------------------------------------------------------------------
//      
procedure TScope.SetYZone (YZone : extended);
begin
   fYZone := 0;
   if (YZone >= fMin) and (YZone <= fMax)
   then fYZone := YZone
   else ShowMessage('       ');
end;
// -------------------------------------------------------------------------
//     
procedure TScope.SetRZone (RZone : extended);
begin
   fRZone := 0;
   if fYZone <> 0
   then begin
     if (RZone > fYZone) and (RZone <= fMax)
     then fRZone := RZone
     else ShowMessage('       ');
   end
   else ShowMessage('       ');
end;
// -------------------------------------------------------------------------
//   
procedure TScope.DrawScope();
var CFields : TColor;
    CValue  : TColor;
begin

   if not fVisible then Exit;
   //     
   CFields := RGB(200,220,240);
   if fValue < 0
   then begin
      CValue := RGB(180,180,255);
      if Abs(fValue) > fYZone then CValue := RGB(100,100,255);
      if Abs(fValue) > fRZone then CValue := RGB(0,0,255);
   end
   else begin
      CValue  := clLime;
      if fValue > fYZone then CValue := clYellow;
      if fValue > fRZone then CValue := clRed;
   end;
   //  
   with fImg.Canvas
   do begin
      // -----------------------------
      if not fTransparent
      then begin
         //    
         Brush.Style := bsSolid;
         Pen.Color := clWhite;
         Brush.Color := CFields;
         Rectangle(fSRect);
         Pen.Color := clBlack;
         MoveTo(fSRect.Left,    fSRect.Bottom-1);
         LineTo(fSRect.Right-1, fSRect.Bottom-1);
         MoveTo(fSRect.Right-1, fSRect.Top);
         LineTo(fSRect.Right-1, fSRect.Bottom);
      end;
      // -----------------------------
      //  
       Brush.Color := CValue;
       Brush.Style := bsSolid;
       Ellipse(fIRect);
       // -----------------------------
       //  
       Brush.Color := CFields;
       Brush.Style := bsSolid;
       FillRect(fVRect);
       TextOut(fVRect.Left, fVRect.Top,
               ' ' + Format(cOutPic, [fValue])
             + ' ' + fMeasure + ' ' );
       // -----------------------------
       if not fCompact
       then begin
          // -----------------------------
          //   
          Brush.Color := CFields;
          Brush.Style := bsSolid;
          Rectangle(fGRect);
          // -----------------------------
          //   
          Brush.Style := bsSolid;
          Brush.Color := CValue;
          Rectangle(fGRect.Left, fGRect.Top,
                    fGRect.Left + Abs(GetGW(fValue)),
                    fGRect.Bottom);
           // -----------------------------
           //  
           if fTitle <> ''
           then begin
             Brush.Color := CFields;
             Brush.Style := bsSolid;
             FillRect(fTRect);
             TextOut(fTRect.Left, fTRect.Top, ' ' + fTitle + ' ');
           end;
       end;
   end;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.
